/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.colorscale.drawer;

import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.NumericColorScale;
import edu.upf.bg.formatter.GenericFormatter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ColorScaleDrawer {
    private NumericColorScale scale;
    private Color bgColor;
    private double zoomRangeMin;
    private double zoomRangeMax;
    private int widthPadding;
    private int heightPadding;
    private int barSize;
    private boolean barBorderEnabled;
    private Color barBorderColor;
    private boolean legendEnabled;
    private Color legendPointColor;
    private int legendPadding;
    private Font legendFont;
    private String legendFormat;

    public ColorScaleDrawer(IColorScale scale) {
        this.setScale(scale);
        this.bgColor = Color.WHITE;
        this.widthPadding = 8;
        this.heightPadding = 8;
        this.barSize = 18;
        this.barBorderEnabled = true;
        this.barBorderColor = Color.BLACK;
        this.legendEnabled = true;
        this.legendPointColor = Color.BLACK;
        this.legendPadding = 4;
        this.legendFont = new Font("SansSerif", 0, 10);
        this.legendFormat = "%.2f";
    }

    public IColorScale getScale() {
        return this.scale;
    }

    public void setScale(IColorScale scale) {
        this.scale = (NumericColorScale)scale;
        this.resetZoom();
    }

    public void resetZoom() {
        this.zoomRangeMin = this.scale.getMinValue();
        this.zoomRangeMax = this.scale.getMaxValue();
    }

    public double getZoomRangeMin() {
        return this.zoomRangeMin;
    }

    public void setZoomRangeMin(double zoomRangeMin) {
        this.zoomRangeMin = zoomRangeMin;
    }

    public double getZoomRangeMax() {
        return this.zoomRangeMax;
    }

    public void setZoomRangeMax(double zoomRangeMax) {
        this.zoomRangeMax = zoomRangeMax;
    }

    public int getBarSize() {
        return this.barSize;
    }

    public void setBarSize(int barSize) {
        this.barSize = barSize;
    }

    public void draw(Graphics2D g, Rectangle bounds, Rectangle clip) {
        g.setColor(this.bgColor);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        bounds.x += this.widthPadding;
        bounds.width -= this.widthPadding * 2;
        bounds.y += this.heightPadding;
        bounds.height -= this.heightPadding * 2;
        int bxs = bounds.x;
        int bxe = bxs + bounds.width - 1;
        int bys = bounds.y;
        int bye = bys + this.barSize - 1;
        double delta = (this.zoomRangeMax - this.zoomRangeMin) / (double)(bxe - bxs);
        double value = this.zoomRangeMin;
        for (int x = bxs; x <= bxe; ++x) {
            Color color = this.scale.valueColor(value);
            g.setColor(color);
            g.drawLine(x, bys, x, bye);
            value += delta;
        }
        if (this.barBorderEnabled) {
            g.setColor(this.barBorderColor);
            g.drawRect(bxs, bys, bxe - bxs, bye - bys);
        }
        if (this.legendEnabled) {
            int fontHeight = g.getFontMetrics().getHeight();
            int ys = bye + this.legendPadding;
            int ye = ys + fontHeight;
            double invDelta = 1.0 / delta;
            GenericFormatter gf = new GenericFormatter();
            g.setColor(this.legendPointColor);
            for (double point : this.scale.getPoints()) {
                if (!(point >= this.zoomRangeMin) || !(point <= this.zoomRangeMax)) continue;
                int x = bxs + (int)((point - this.zoomRangeMin) * invDelta);
                g.drawLine(x, bys, x, ye);
                String legend = gf.format(this.legendFormat, point);
                int fontWidth = g.getFontMetrics().stringWidth(legend);
                x = x + 2 + fontWidth > bxe ? x - fontWidth - 2 : (x += 2);
                g.drawString(legend, x, ye);
            }
        }
    }

    public Dimension getSize() {
        int height = this.heightPadding * 2 + this.barSize;
        if (this.legendEnabled) {
            BufferedImage image = new BufferedImage(1, 1, 2);
            Graphics g = image.getGraphics();
            height += g.getFontMetrics(this.legendFont).getHeight() + this.legendPadding;
        }
        int width = this.widthPadding + 20;
        return new Dimension(width, height);
    }
}

