/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.colorscale;

import edu.upf.bg.color.utils.ColorUtils;
import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.IColorScaleHtml;
import edu.upf.bg.colorscale.util.ColorConstants;
import java.awt.Color;

public abstract class NumericColorScale
implements IColorScale,
IColorScaleHtml {
    private Color notANumberColor;
    private Color posInfinityColor;
    private Color negInfinityColor;
    private Color emptyColor;

    protected NumericColorScale() {
    }

    @Override
    public Color valueColor(double value) {
        Color color = this.limitsColor(value);
        if (color != null) {
            return color;
        }
        return this.colorOf(value);
    }

    protected abstract Color colorOf(double var1);

    public abstract double[] getPoints();

    public double getMinValue() {
        return this.getPoints()[0];
    }

    public double getMaxValue() {
        return this.getPoints()[this.getPoints().length - 1];
    }

    @Override
    public String valueRGBHtmlColor(double value) {
        Color color = this.valueColor(value);
        return ColorUtils.colorToRGBHtml(color);
    }

    @Override
    public String valueHexHtmlColor(double value) {
        Color color = this.valueColor(value);
        return ColorUtils.colorToHexHtml(color);
    }

    public Color limitsColor(double value) {
        if (Double.isNaN(value)) {
            return this.getNotANumberColor();
        }
        if (value == Double.POSITIVE_INFINITY) {
            return this.getPosInfinityColor();
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return this.getNegInfinityColor();
        }
        return null;
    }

    public Color getNotANumberColor() {
        if (this.notANumberColor == null) {
            return ColorConstants.notANumberColor;
        }
        return this.notANumberColor;
    }

    public void setNotANumberColor(Color notANumberColor) {
        this.notANumberColor = notANumberColor;
    }

    public Color getPosInfinityColor() {
        if (this.posInfinityColor == null) {
            return ColorConstants.posInfinityColor;
        }
        return this.posInfinityColor;
    }

    public void setPosInfinityColor(Color posInfinityColor) {
        this.posInfinityColor = posInfinityColor;
    }

    public Color getNegInfinityColor() {
        if (this.negInfinityColor == null) {
            return ColorConstants.negInfinityColor;
        }
        return this.negInfinityColor;
    }

    public void setNegInfinityColor(Color negInfinityColor) {
        this.negInfinityColor = negInfinityColor;
    }

    public Color getEmptyColor() {
        if (this.emptyColor == null) {
            return ColorConstants.emptyColor;
        }
        return this.emptyColor;
    }

    public void setEmptyColor(Color emptyColor) {
        this.emptyColor = emptyColor;
    }
}

