/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.color.utils;

import java.awt.color.ColorSpace;

public class HLSColorSpace
extends ColorSpace {
    public HLSColorSpace() {
        super(8, 3);
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        float R = 0.0f;
        float G = 0.0f;
        float B = 0.0f;
        float H = colorvalue[0];
        float L = colorvalue[1];
        float S = colorvalue[2];
        if (L <= 0.0f) {
            B = 0.0f;
            G = 0.0f;
            R = 0.0f;
        } else if (L >= 1.0f) {
            B = 1.0f;
            G = 1.0f;
            R = 1.0f;
        } else {
            float hh = 6.0f * H % 6.0f;
            int c1 = (int)hh;
            float c2 = hh - (float)c1;
            float d = L <= 0.5f ? S * L : S * (1.0f - L);
            float w = L + d;
            float x = L - d;
            float y = w - (w - x) * c2;
            float z = x + (w - x) * c2;
            switch (c1) {
                case 0: {
                    R = w;
                    G = z;
                    B = x;
                    break;
                }
                case 1: {
                    R = y;
                    G = w;
                    B = x;
                    break;
                }
                case 2: {
                    R = x;
                    G = w;
                    B = z;
                    break;
                }
                case 3: {
                    R = x;
                    G = y;
                    B = w;
                    break;
                }
                case 4: {
                    R = z;
                    G = x;
                    B = w;
                    break;
                }
                case 5: {
                    R = w;
                    G = x;
                    B = y;
                }
            }
        }
        return new float[]{R, G, B};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

