/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.color.utils;

import java.awt.Color;

public class ColorUtils {
    public static Color mix(Color src, Color dst, double factor) {
        double fs = factor / 255.0;
        double fd = (1.0 - factor) / 255.0;
        double r = (double)src.getRed() * fs + (double)dst.getRed() * fd;
        double g = (double)src.getGreen() * fs + (double)dst.getGreen() * fd;
        double b = (double)src.getBlue() * fs + (double)dst.getBlue() * fd;
        int ir = Math.max(0, Math.min(255, (int)Math.round(r * 255.0)));
        int ig = Math.max(0, Math.min(255, (int)Math.round(g * 255.0)));
        int ib = Math.max(0, Math.min(255, (int)Math.round(b * 255.0)));
        return new Color(ir, ig, ib);
    }

    public static String colorToRGBHtml(Color color) {
        StringBuilder sb = new StringBuilder();
        sb.append("rgb(");
        sb.append(color.getRed()).append(',');
        sb.append(color.getGreen()).append(',');
        sb.append(color.getBlue()).append(')');
        return sb.toString();
    }

    public static String colorToHexHtml(Color color) {
        return "#" + Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static Color invert(Color color) {
        int r = 255 - color.getRed();
        int g = 255 - color.getGreen();
        int b = 255 - color.getBlue();
        return new Color(r, g, b);
    }
}

