/*
 * Decompiled with CFR 0.152.
 */
package edu.upf.bg.benchmark;

public class TimeCounter {
    private boolean paused;
    private long elapsed = 0L;
    private long start;

    public TimeCounter() {
        this.start();
    }

    public void start() {
        this.paused = false;
        this.start = System.nanoTime();
    }

    public void pause() {
        this.paused = true;
        this.elapsed = this.getElapsed();
    }

    public void reset() {
        this.elapsed = 0L;
        this.start = System.nanoTime();
    }

    public long getElapsed() {
        if (!this.paused) {
            return this.elapsed + (System.nanoTime() - this.start);
        }
        return this.elapsed;
    }

    public float getElapsedSeconds() {
        return (float)this.getElapsed() / 1.0E9f;
    }

    public String toString() {
        long e = this.getElapsed();
        double millis = (double)e / 1000000.0;
        double secs = (double)e / 1.0E9;
        double mins = (double)e / 6.0E10;
        String time = "";
        time = millis < 1000.0 ? Double.toString(millis) + " millisecs" : (secs < 60.0 ? Double.toString(secs) + " secs" : Double.toString(mins) + " mins");
        return time;
    }
}

