/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.parser.ElementInfo;
import org.lobobrowser.html.parser.LocatorImpl;
import org.lobobrowser.html.parser.StopException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HtmlParser {
    private static final Logger logger = Logger.getLogger(HtmlParser.class.getName());
    private final Document document;
    private final UserAgentContext ucontext;
    private final ErrorHandler errorHandler;
    private final String publicId;
    private final String systemId;
    private static final Map ENTITIES = new HashMap(256);
    private static final Map ELEMENT_INFOS = new HashMap(35);
    public static final String MODIFYING_KEY = "cobra.suspend";
    private static final int TOKEN_EOD = 0;
    private static final int TOKEN_COMMENT = 1;
    private static final int TOKEN_TEXT = 2;
    private static final int TOKEN_BEGIN_ELEMENT = 3;
    private static final int TOKEN_END_ELEMENT = 4;
    private static final int TOKEN_FULL_ELEMENT = 5;
    private static final int TOKEN_BAD = 6;
    private String normalLastTag = null;
    private boolean justReadTagBegin = false;
    private boolean justReadTagEnd = false;
    private boolean justReadEmptyElement = false;

    public HtmlParser(Document document, ErrorHandler errorHandler, String publicId, String systemId) {
        this.ucontext = null;
        this.document = document;
        this.errorHandler = errorHandler;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public HtmlParser(UserAgentContext ucontext, Document document, ErrorHandler errorHandler, String publicId, String systemId) {
        this.ucontext = ucontext;
        this.document = document;
        this.errorHandler = errorHandler;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public HtmlParser(UserAgentContext ucontext, Document document) {
        this.ucontext = ucontext;
        this.document = document;
        this.errorHandler = null;
        this.publicId = null;
        this.systemId = null;
    }

    public static boolean isDecodeEntities(String elementName) {
        ElementInfo einfo = (ElementInfo)ELEMENT_INFOS.get(elementName.toUpperCase());
        return einfo == null ? true : einfo.decodeEntities;
    }

    public void parse(InputStream in) throws IOException, SAXException, UnsupportedEncodingException {
        this.parse(in, "ISO-8859-1");
    }

    public void parse(InputStream in, String charset) throws IOException, SAXException, UnsupportedEncodingException {
        WritableLineReader reader = new WritableLineReader(new InputStreamReader(in, charset));
        this.parse(reader);
    }

    public void parse(Reader reader) throws IOException, SAXException {
        this.parse(new LineNumberReader(reader));
    }

    public void parse(LineNumberReader reader) throws IOException, SAXException {
        Document doc = this.document;
        this.parse(reader, (Node)doc);
    }

    public void parse(Reader reader, Node parent) throws IOException, SAXException {
        this.parse(new LineNumberReader(reader), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(LineNumberReader reader, Node parent) throws IOException, SAXException {
        try {
            parent.setUserData(MODIFYING_KEY, Boolean.TRUE, null);
            try {
                while (this.parseToken(parent, reader, null, new LinkedList()) != 0) {
                }
            }
            catch (StopException se) {
                throw new SAXException("Unexpected flow exception", se);
            }
        }
        finally {
            parent.setUserData(MODIFYING_KEY, Boolean.FALSE, null);
        }
    }

    /*
     * Exception decompiling
     */
    private final int parseToken(Node parent, LineNumberReader reader, Set stopTags, LinkedList ancestors) throws IOException, StopException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 28[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final StringBuffer readUpToTagBegin(LineNumberReader reader) throws IOException, SAXException {
        int intCh;
        StringBuffer sb = null;
        while ((intCh = reader.read()) != -1) {
            char ch = (char)intCh;
            if (ch == '<') {
                this.justReadTagBegin = true;
                this.justReadTagEnd = false;
                this.justReadEmptyElement = false;
                if (sb == null) {
                    sb = new StringBuffer(0);
                }
                return sb;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(ch);
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = false;
        this.justReadEmptyElement = false;
        return sb;
    }

    private final int parseForEndTag(Node parent, LineNumberReader reader, String tagName, boolean addTextNode, boolean decodeEntities) throws IOException, SAXException {
        int intCh;
        Document doc = this.document;
        StringBuffer sb = new StringBuffer();
        while ((intCh = reader.read()) != -1) {
            char ch = (char)intCh;
            if (ch == '<' && (intCh = reader.read()) != -1) {
                ch = (char)intCh;
                if (ch == '/') {
                    StringBuffer tempBuffer = new StringBuffer();
                    while ((intCh = reader.read()) != -1) {
                        ch = (char)intCh;
                        if (ch == '>') {
                            String thisTag = tempBuffer.toString().trim();
                            if (!thisTag.equalsIgnoreCase(tagName)) break;
                            this.justReadTagBegin = false;
                            this.justReadTagEnd = true;
                            this.justReadEmptyElement = false;
                            this.normalLastTag = thisTag.toUpperCase();
                            if (addTextNode) {
                                String text;
                                if (decodeEntities) {
                                    sb = this.entityDecode(sb);
                                }
                                if ((text = sb.toString()).length() != 0) {
                                    Text textNode = doc.createTextNode(text);
                                    parent.appendChild(textNode);
                                }
                            }
                            return 4;
                        }
                        tempBuffer.append(ch);
                    }
                    sb.append("</");
                    sb.append(tempBuffer);
                } else {
                    sb.append('<');
                }
            }
            sb.append(ch);
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = false;
        this.justReadEmptyElement = false;
        if (addTextNode) {
            String text;
            if (decodeEntities) {
                sb = this.entityDecode(sb);
            }
            if ((text = sb.toString()).length() != 0) {
                Text textNode = doc.createTextNode(text);
                parent.appendChild(textNode);
            }
        }
        return 0;
    }

    private final String readTag(Node parent, LineNumberReader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        int chInt = reader.read();
        if (chInt != -1) {
            char ch;
            boolean cont = true;
            while (!Character.isLetter(ch = (char)chInt)) {
                block23: {
                    Text textNode;
                    Document doc;
                    StringBuffer ltText;
                    if (ch == '!') {
                        sb.append('!');
                        chInt = reader.read();
                        if (chInt != -1) {
                            ch = (char)chInt;
                            if (ch != '-') break;
                            sb.append('-');
                            chInt = reader.read();
                            if (chInt != -1) {
                                ch = (char)chInt;
                                if (ch != '-') break;
                                sb.append('-');
                                cont = false;
                                break;
                            }
                            cont = false;
                            break;
                        }
                        cont = false;
                        break;
                    }
                    if (ch == '/') {
                        sb.append(ch);
                        chInt = reader.read();
                        if (chInt != -1) {
                            ch = (char)chInt;
                            break;
                        }
                        cont = false;
                        break;
                    }
                    if (ch == '<') {
                        block22: {
                            ltText = new StringBuffer(3);
                            ltText.append('<');
                            while ((chInt = reader.read()) == 60) {
                                ltText.append('<');
                            }
                            doc = this.document;
                            textNode = doc.createTextNode(ltText.toString());
                            try {
                                parent.appendChild(textNode);
                            }
                            catch (DOMException de) {
                                if (parent.getNodeType() == 9 && de.code == 3) break block22;
                                logger.log(Level.WARNING, "parseToken(): Unable to append child to " + parent + ".", de);
                            }
                        }
                        if (chInt != -1) continue;
                        cont = false;
                        break;
                    }
                    if (!Character.isWhitespace(ch)) break;
                    ltText = new StringBuffer();
                    ltText.append('<');
                    ltText.append(ch);
                    while ((chInt = reader.read()) != -1) {
                        ch = (char)chInt;
                        if (ch == '<') {
                            chInt = reader.read();
                            break;
                        }
                        ltText.append(ch);
                    }
                    doc = this.document;
                    textNode = doc.createTextNode(ltText.toString());
                    try {
                        parent.appendChild(textNode);
                    }
                    catch (DOMException de) {
                        if (parent.getNodeType() == 9 && de.code == 3) break block23;
                        logger.log(Level.WARNING, "parseToken(): Unable to append child to " + parent + ".", de);
                    }
                }
                if (chInt != -1) continue;
                cont = false;
                break;
            }
            if (cont) {
                boolean lastCharSlash = false;
                while (!Character.isWhitespace(ch)) {
                    if (ch == '>') {
                        this.justReadTagEnd = true;
                        this.justReadTagBegin = false;
                        this.justReadEmptyElement = lastCharSlash;
                        String tag = sb.toString();
                        return tag;
                    }
                    if (ch == '/') {
                        lastCharSlash = true;
                    } else {
                        if (lastCharSlash) {
                            sb.append('/');
                        }
                        lastCharSlash = false;
                        sb.append(ch);
                    }
                    chInt = reader.read();
                    if (chInt == -1) break;
                    ch = (char)chInt;
                }
            }
        }
        if (sb.length() > 0) {
            this.justReadTagEnd = false;
            this.justReadTagBegin = false;
            this.justReadEmptyElement = false;
        }
        String tag = sb.toString();
        return tag;
    }

    private final StringBuffer passEndOfComment(LineNumberReader reader) throws IOException {
        int chInt;
        if (this.justReadTagEnd) {
            return new StringBuffer(0);
        }
        StringBuffer sb = new StringBuffer();
        block0: while ((chInt = reader.read()) != -1) {
            char ch = (char)chInt;
            if (ch == '-') {
                chInt = reader.read();
                if (chInt == -1) {
                    sb.append(ch);
                    break;
                }
                ch = (char)chInt;
                if (ch == '-') {
                    StringBuffer extra = null;
                    while (true) {
                        if ((chInt = reader.read()) == -1) {
                            if (extra == null) break block0;
                            sb.append(extra.toString());
                            break block0;
                        }
                        ch = (char)chInt;
                        if (ch == '>') {
                            this.justReadTagBegin = false;
                            this.justReadTagEnd = true;
                            return sb;
                        }
                        if (ch == '-') {
                            if (extra == null) {
                                extra = new StringBuffer();
                                extra.append("--");
                            }
                            extra.append("-");
                            continue;
                        }
                        if (!Character.isWhitespace(ch)) break;
                        if (extra == null) {
                            extra = new StringBuffer();
                            extra.append("--");
                        }
                        extra.append(ch);
                    }
                    if (extra != null) {
                        sb.append(extra.toString());
                    }
                    sb.append(ch);
                    continue;
                }
                sb.append('-');
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            this.justReadTagBegin = false;
            this.justReadTagEnd = false;
        }
        return sb;
    }

    private final void passEndOfTag(Reader reader) throws IOException {
        int chInt;
        if (this.justReadTagEnd) {
            return;
        }
        boolean readSomething = false;
        while ((chInt = reader.read()) != -1) {
            readSomething = true;
            char ch = (char)chInt;
            if (ch != '>') continue;
            this.justReadTagEnd = true;
            this.justReadTagBegin = false;
            return;
        }
        if (readSomething) {
            this.justReadTagBegin = false;
            this.justReadTagEnd = false;
        }
    }

    private final StringBuffer readProcessingInstruction(LineNumberReader reader) throws IOException {
        StringBuffer pidata = new StringBuffer();
        if (this.justReadTagEnd) {
            return pidata;
        }
        int ch = reader.read();
        while (ch != -1 && ch != 62) {
            pidata.append((char)ch);
            ch = reader.read();
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = ch != -1;
        return pidata;
    }

    private final boolean readAttribute(LineNumberReader reader, Element element) throws IOException, SAXException {
        int ch;
        int chInt;
        if (this.justReadTagEnd) {
            return false;
        }
        StringBuffer attributeName = null;
        boolean blankFound = false;
        boolean lastCharSlash = false;
        while (true) {
            String attributeNameStr;
            int chInt2;
            if ((chInt2 = reader.read()) == -1) {
                if (attributeName != null && attributeName.length() != 0) {
                    String attributeNameStr2 = attributeName.toString();
                    element.setAttribute(attributeNameStr2, attributeNameStr2);
                    attributeName.setLength(0);
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = false;
                this.justReadEmptyElement = false;
                return false;
            }
            char ch2 = (char)chInt2;
            if (ch2 == '=') break;
            if (ch2 == '>') {
                if (attributeName != null && attributeName.length() != 0) {
                    attributeNameStr = attributeName.toString();
                    element.setAttribute(attributeNameStr, attributeNameStr);
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = true;
                this.justReadEmptyElement = lastCharSlash;
                return false;
            }
            if (ch2 == '/') {
                blankFound = true;
                lastCharSlash = true;
                continue;
            }
            if (Character.isWhitespace(ch2)) {
                lastCharSlash = false;
                blankFound = true;
                continue;
            }
            lastCharSlash = false;
            if (blankFound) {
                blankFound = false;
                if (attributeName != null && attributeName.length() != 0) {
                    attributeNameStr = attributeName.toString();
                    element.setAttribute(attributeNameStr, attributeNameStr);
                    attributeName.setLength(0);
                }
            }
            if (attributeName == null) {
                attributeName = new StringBuffer(6);
            }
            attributeName.append(ch2);
        }
        lastCharSlash = false;
        blankFound = false;
        StringBuffer attributeValue = null;
        int openQuote = -1;
        while ((chInt = reader.read()) != -1) {
            ch = chInt;
            if (ch == 62) {
                if (attributeName != null && attributeName.length() != 0) {
                    String attributeNameStr = attributeName.toString();
                    element.setAttribute(attributeNameStr, attributeNameStr);
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = true;
                this.justReadEmptyElement = lastCharSlash;
                return false;
            }
            if (ch == 47) {
                lastCharSlash = true;
                continue;
            }
            if (Character.isWhitespace((char)ch)) {
                lastCharSlash = false;
                continue;
            }
            lastCharSlash = false;
            if (ch == 34) {
                openQuote = 34;
                break;
            }
            if (ch == 39) {
                openQuote = 39;
                break;
            }
            openQuote = -1;
            if (attributeValue == null) {
                attributeValue = new StringBuffer(6);
            }
            attributeValue.append((char)ch);
            break;
        }
        while ((chInt = reader.read()) != -1) {
            ch = (char)chInt;
            if (openQuote != -1 && ch == openQuote) {
                lastCharSlash = false;
                if (attributeName != null) {
                    String attributeNameStr = attributeName.toString();
                    if (attributeValue == null) {
                        element.setAttribute(attributeNameStr, "");
                    } else {
                        StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                        element.setAttribute(attributeNameStr, actualAttributeValue.toString());
                    }
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = false;
                return true;
            }
            if (openQuote == -1 && ch == 62) {
                if (attributeName != null) {
                    String attributeNameStr = attributeName.toString();
                    if (attributeValue == null) {
                        element.setAttribute(attributeNameStr, null);
                    } else {
                        StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                        element.setAttribute(attributeNameStr, actualAttributeValue.toString());
                    }
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = true;
                this.justReadEmptyElement = lastCharSlash;
                return false;
            }
            if (openQuote == -1 && Character.isWhitespace((char)ch)) {
                lastCharSlash = false;
                if (attributeName != null) {
                    String attributeNameStr = attributeName.toString();
                    if (attributeValue == null) {
                        element.setAttribute(attributeNameStr, null);
                    } else {
                        StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                        element.setAttribute(attributeNameStr, actualAttributeValue.toString());
                    }
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = false;
                return true;
            }
            if (attributeValue == null) {
                attributeValue = new StringBuffer(6);
            }
            if (lastCharSlash) {
                attributeValue.append('/');
            }
            lastCharSlash = false;
            attributeValue.append((char)ch);
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = false;
        if (attributeName != null) {
            String attributeNameStr = attributeName.toString();
            if (attributeValue == null) {
                element.setAttribute(attributeNameStr, null);
            } else {
                StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                element.setAttribute(attributeNameStr, actualAttributeValue.toString());
            }
        }
        return false;
    }

    private final StringBuffer entityDecode(StringBuffer rawText) throws SAXException {
        int startIdx = 0;
        StringBuffer sb = null;
        while (true) {
            int ampIdx;
            if ((ampIdx = rawText.indexOf("&", startIdx)) == -1) {
                if (sb == null) {
                    return rawText;
                }
                sb.append(rawText.substring(startIdx));
                return sb;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(rawText.substring(startIdx, ampIdx));
            int colonIdx = rawText.indexOf(";", ampIdx);
            if (colonIdx == -1) {
                sb.append('&');
                startIdx = ampIdx + 1;
                continue;
            }
            String spec = rawText.substring(ampIdx + 1, colonIdx);
            if (spec.startsWith("#")) {
                int decimal;
                String number = spec.substring(1).toLowerCase();
                try {
                    decimal = number.startsWith("x") ? Integer.parseInt(number.substring(1), 16) : Integer.parseInt(number);
                }
                catch (NumberFormatException nfe) {
                    logger.log(Level.WARNING, "entityDecode()", nfe);
                    decimal = 0;
                }
                sb.append((char)decimal);
            } else {
                int chInt = this.getEntityChar(spec);
                if (chInt == -1) {
                    sb.append('&');
                    sb.append(spec);
                    sb.append(';');
                } else {
                    sb.append((char)chInt);
                }
            }
            startIdx = colonIdx + 1;
        }
    }

    private final Locator getLocator(int lineNumber, int columnNumber) {
        return new LocatorImpl(this.publicId, this.systemId, lineNumber, columnNumber);
    }

    private final int getEntityChar(String spec) {
        String specTL;
        Character c = (Character)ENTITIES.get(spec);
        if (c == null && (c = (Character)ENTITIES.get(specTL = spec.toLowerCase())) == null) {
            return -1;
        }
        return c.charValue();
    }

    static {
        Map entities = ENTITIES;
        entities.put("amp", new Character('&'));
        entities.put("lt", new Character('<'));
        entities.put("gt", new Character('>'));
        entities.put("quot", new Character('\"'));
        entities.put("nbsp", new Character('\u00a0'));
        entities.put("lsquo", new Character('\u2018'));
        entities.put("rsquo", new Character('\u2019'));
        entities.put("frasl", new Character('/'));
        entities.put("ndash", new Character('\u2013'));
        entities.put("mdash", new Character('\u2014'));
        entities.put("iexcl", new Character('\u00a1'));
        entities.put("cent", new Character('\u00a2'));
        entities.put("pound", new Character('\u00a3'));
        entities.put("curren", new Character('\u00a4'));
        entities.put("yen", new Character('\u00a5'));
        entities.put("brvbar", new Character('\u00a6'));
        entities.put("brkbar", new Character('\u00a6'));
        entities.put("sect", new Character('\u00a7'));
        entities.put("uml", new Character('\u00a8'));
        entities.put("die", new Character('\u00a8'));
        entities.put("copy", new Character('\u00a9'));
        entities.put("ordf", new Character('\u00aa'));
        entities.put("laquo", new Character('\u00ab'));
        entities.put("not", new Character('\u00ac'));
        entities.put("shy", new Character('\u00ad'));
        entities.put("reg", new Character('\u00ae'));
        entities.put("macr", new Character('\u00af'));
        entities.put("hibar", new Character('\u00af'));
        entities.put("deg", new Character('\u00b0'));
        entities.put("plusmn", new Character('\u00b1'));
        entities.put("sup2", new Character('\u00b2'));
        entities.put("sup3", new Character('\u00b3'));
        entities.put("acute", new Character('\u00b4'));
        entities.put("micro", new Character('\u00b5'));
        entities.put("para", new Character('\u00b6'));
        entities.put("middot", new Character('\u00b7'));
        entities.put("cedil", new Character('\u00b8'));
        entities.put("sup1", new Character('\u00b9'));
        entities.put("ordm", new Character('\u00ba'));
        entities.put("raquo", new Character('\u00bb'));
        entities.put("frac14", new Character('\u00bc'));
        entities.put("frac12", new Character('\u00bd'));
        entities.put("frac34", new Character('\u00be'));
        entities.put("iquest", new Character('\u00bf'));
        entities.put("Agrave", new Character('\u00c0'));
        entities.put("Aacute", new Character('\u00c1'));
        entities.put("Acirc", new Character('\u00c2'));
        entities.put("Atilde", new Character('\u00c3'));
        entities.put("Auml", new Character('\u00c4'));
        entities.put("Aring", new Character('\u00c5'));
        entities.put("AElig", new Character('\u00c6'));
        entities.put("Ccedil", new Character('\u00c7'));
        entities.put("Egrave", new Character('\u00c8'));
        entities.put("Eacute", new Character('\u00c9'));
        entities.put("Ecirc", new Character('\u00ca'));
        entities.put("Euml", new Character('\u00cb'));
        entities.put("Igrave", new Character('\u00cc'));
        entities.put("Iacute", new Character('\u00cd'));
        entities.put("Icirc", new Character('\u00ce'));
        entities.put("Iuml", new Character('\u00cf'));
        entities.put("ETH", new Character('\u00d0'));
        entities.put("Ntilde", new Character('\u00d1'));
        entities.put("Ograve", new Character('\u00d2'));
        entities.put("Oacute", new Character('\u00d3'));
        entities.put("Ocirc", new Character('\u00d4'));
        entities.put("Otilde", new Character('\u00d5'));
        entities.put("Ouml", new Character('\u00d6'));
        entities.put("times", new Character('\u00d7'));
        entities.put("Oslash", new Character('\u00d8'));
        entities.put("Ugrave", new Character('\u00d9'));
        entities.put("Uacute", new Character('\u00da'));
        entities.put("Ucirc", new Character('\u00db'));
        entities.put("Uuml", new Character('\u00dc'));
        entities.put("Yacute", new Character('\u00dd'));
        entities.put("THORN", new Character('\u00de'));
        entities.put("szlig", new Character('\u00df'));
        entities.put("agrave", new Character('\u00e0'));
        entities.put("aacute", new Character('\u00e1'));
        entities.put("acirc", new Character('\u00e2'));
        entities.put("atilde", new Character('\u00e3'));
        entities.put("auml", new Character('\u00e4'));
        entities.put("aring", new Character('\u00e5'));
        entities.put("aelig", new Character('\u00e6'));
        entities.put("ccedil", new Character('\u00e7'));
        entities.put("egrave", new Character('\u00e8'));
        entities.put("eacute", new Character('\u00e9'));
        entities.put("ecirc", new Character('\u00ea'));
        entities.put("euml", new Character('\u00eb'));
        entities.put("igrave", new Character('\u00ec'));
        entities.put("iacute", new Character('\u00ed'));
        entities.put("icirc", new Character('\u00ee'));
        entities.put("iuml", new Character('\u00ef'));
        entities.put("eth", new Character('\u00f0'));
        entities.put("ntilde", new Character('\u00f1'));
        entities.put("ograve", new Character('\u00f2'));
        entities.put("oacute", new Character('\u00f3'));
        entities.put("ocirc", new Character('\u00f4'));
        entities.put("otilde", new Character('\u00f5'));
        entities.put("ouml", new Character('\u00f6'));
        entities.put("divide", new Character('\u00f7'));
        entities.put("oslash", new Character('\u00f8'));
        entities.put("ugrave", new Character('\u00f9'));
        entities.put("uacute", new Character('\u00fa'));
        entities.put("ucirc", new Character('\u00fb'));
        entities.put("uuml", new Character('\u00fc'));
        entities.put("yacute", new Character('\u00fd'));
        entities.put("thorn", new Character('\u00fe'));
        entities.put("yuml", new Character('\u00ff'));
        entities.put("Alpha", new Character('\u0391'));
        entities.put("Beta", new Character('\u0392'));
        entities.put("Gamma", new Character('\u0393'));
        entities.put("Delta", new Character('\u0394'));
        entities.put("Epsilon", new Character('\u0395'));
        entities.put("Zeta", new Character('\u0396'));
        entities.put("Eta", new Character('\u0397'));
        entities.put("Theta", new Character('\u0398'));
        entities.put("Iota", new Character('\u0399'));
        entities.put("Kappa", new Character('\u039a'));
        entities.put("Lambda", new Character('\u039b'));
        entities.put("Mu", new Character('\u039c'));
        entities.put("Nu", new Character('\u039d'));
        entities.put("Xi", new Character('\u039e'));
        entities.put("Omicron", new Character('\u039f'));
        entities.put("Pi", new Character('\u03a0'));
        entities.put("Rho", new Character('\u03a1'));
        entities.put("Sigma", new Character('\u03a2'));
        entities.put("Sigmaf", new Character('\u03a3'));
        entities.put("Tau", new Character('\u03a4'));
        entities.put("Upsilon", new Character('\u03a5'));
        entities.put("Phi", new Character('\u03a6'));
        entities.put("Chi", new Character('\u03a7'));
        entities.put("Psi", new Character('\u03a8'));
        entities.put("Omega", new Character('\u03a9'));
        entities.put("alpha", new Character('\u03b1'));
        entities.put("beta", new Character('\u03b2'));
        entities.put("gamma", new Character('\u03b3'));
        entities.put("delta", new Character('\u03b4'));
        entities.put("epsilon", new Character('\u03b5'));
        entities.put("zeta", new Character('\u03b6'));
        entities.put("eta", new Character('\u03b7'));
        entities.put("theta", new Character('\u03b8'));
        entities.put("iota", new Character('\u03b9'));
        entities.put("kappa", new Character('\u03ba'));
        entities.put("lambda", new Character('\u03bb'));
        entities.put("mu", new Character('\u03bc'));
        entities.put("nu", new Character('\u03bd'));
        entities.put("xi", new Character('\u03be'));
        entities.put("omicron", new Character('\u03bf'));
        entities.put("pi", new Character('\u03c0'));
        entities.put("rho", new Character('\u03c1'));
        entities.put("sigma", new Character('\u03c2'));
        entities.put("sigmaf", new Character('\u03c3'));
        entities.put("tau", new Character('\u03c4'));
        entities.put("upsilon", new Character('\u03c5'));
        entities.put("phi", new Character('\u03c6'));
        entities.put("chi", new Character('\u03c7'));
        entities.put("psi", new Character('\u03c8'));
        entities.put("omega", new Character('\u03c9'));
        entities.put("thetasym", new Character('\u03d1'));
        entities.put("upsih", new Character('\u03d2'));
        entities.put("piv", new Character('\u03d6'));
        entities.put("forall", new Character('\u2200'));
        entities.put("part", new Character('\u2202'));
        entities.put("exist", new Character('\u2203'));
        entities.put("empty", new Character('\u2205'));
        entities.put("nabla", new Character('\u2207'));
        entities.put("isin", new Character('\u2208'));
        entities.put("notin", new Character('\u2209'));
        entities.put("ni", new Character('\u220b'));
        entities.put("prod", new Character('\u220f'));
        entities.put("sum", new Character('\u2211'));
        entities.put("minus", new Character('\u2212'));
        entities.put("lowast", new Character('\u2217'));
        entities.put("radic", new Character('\u221a'));
        entities.put("prop", new Character('\u221d'));
        entities.put("infin", new Character('\u221e'));
        entities.put("ang", new Character('\u2220'));
        entities.put("and", new Character('\u2227'));
        entities.put("or", new Character('\u2228'));
        entities.put("cap", new Character('\u2229'));
        entities.put("cup", new Character('\u222a'));
        entities.put("int", new Character('\u222b'));
        entities.put("there4", new Character('\u2234'));
        entities.put("sim", new Character('\u223c'));
        entities.put("cong", new Character('\u2245'));
        entities.put("asymp", new Character('\u2248'));
        entities.put("ne", new Character('\u2260'));
        entities.put("equiv", new Character('\u2261'));
        entities.put("le", new Character('\u2264'));
        entities.put("ge", new Character('\u2265'));
        entities.put("sub", new Character('\u2282'));
        entities.put("sup", new Character('\u2283'));
        entities.put("nsub", new Character('\u2284'));
        entities.put("sube", new Character('\u2286'));
        entities.put("supe", new Character('\u2287'));
        entities.put("oplus", new Character('\u2295'));
        entities.put("otimes", new Character('\u2297'));
        entities.put("perp", new Character('\u22a5'));
        entities.put("sdot", new Character('\u22c5'));
        entities.put("loz", new Character('\u25ca'));
        entities.put("lceil", new Character('\u2308'));
        entities.put("rceil", new Character('\u2309'));
        entities.put("lfloor", new Character('\u230a'));
        entities.put("rfloor", new Character('\u230b'));
        entities.put("lang", new Character('\u2329'));
        entities.put("rang", new Character('\u232a'));
        entities.put("larr", new Character('\u2190'));
        entities.put("uarr", new Character('\u2191'));
        entities.put("rarr", new Character('\u2192'));
        entities.put("darr", new Character('\u2193'));
        entities.put("harr", new Character('\u2194'));
        entities.put("crarr", new Character('\u21b5'));
        entities.put("lArr", new Character('\u21d0'));
        entities.put("uArr", new Character('\u21d1'));
        entities.put("rArr", new Character('\u21d2'));
        entities.put("dArr", new Character('\u21d3'));
        entities.put("hArr", new Character('\u2300'));
        entities.put("bull", new Character('\u2022'));
        entities.put("prime", new Character('\u2032'));
        entities.put("Prime", new Character('\u2033'));
        entities.put("oline", new Character('\u203e'));
        entities.put("weierp", new Character('\u2118'));
        entities.put("image", new Character('\u2111'));
        entities.put("real", new Character('\u211c'));
        entities.put("trade", new Character('\u2122'));
        entities.put("euro", new Character('\u20ac'));
        entities.put("alefsym", new Character('\u2135'));
        entities.put("spades", new Character('\u2660'));
        entities.put("clubs", new Character('\u2663'));
        entities.put("hearts", new Character('\u2665'));
        entities.put("diams", new Character('\u2666'));
        entities.put("OElig", new Character('\u0152'));
        entities.put("oelig", new Character('\u0153'));
        entities.put("Scaron", new Character('\u0160'));
        entities.put("scaron", new Character('\u0161'));
        entities.put("fnof", new Character('\u0192'));
        entities.put("ensp", new Character('\u2002'));
        entities.put("emsp", new Character('\u2003'));
        entities.put("thinsp", new Character('\u2009'));
        entities.put("zwnj", new Character('\u200c'));
        entities.put("zwj", new Character('\u200d'));
        entities.put("lrm", new Character('\u200e'));
        entities.put("rlm", new Character('\u200f'));
        entities.put("sbquo", new Character('\u201a'));
        entities.put("ldquo", new Character('\u201c'));
        entities.put("rdquo", new Character('\u201d'));
        entities.put("bdquo", new Character('\u201e'));
        entities.put("dagger", new Character('\u2020'));
        entities.put("Dagger", new Character('\u2021'));
        entities.put("hellip", new Character('\u2026'));
        entities.put("permil", new Character('\u2030'));
        entities.put("lsaquo", new Character('\u2039'));
        entities.put("rsaquo", new Character('\u203a'));
        entities.put("circ", new Character('\u02c6'));
        entities.put("tilde", new Character('\u02dc'));
        Map elementInfos = ELEMENT_INFOS;
        elementInfos.put("NOSCRIPT", new ElementInfo(true, 2, null, true));
        ElementInfo optionalEndElement = new ElementInfo(true, 1);
        ElementInfo forbiddenEndElement = new ElementInfo(false, 0);
        ElementInfo onlyTextDE = new ElementInfo(false, 2, true);
        ElementInfo onlyText = new ElementInfo(false, 2, false);
        HashSet<String> tableCellStopElements = new HashSet<String>();
        tableCellStopElements.add("TH");
        tableCellStopElements.add("TD");
        tableCellStopElements.add("TR");
        ElementInfo tableCellElement = new ElementInfo(true, 1, tableCellStopElements);
        HashSet<String> headStopElements = new HashSet<String>();
        headStopElements.add("BODY");
        headStopElements.add("DIV");
        headStopElements.add("SPAN");
        headStopElements.add("TABLE");
        ElementInfo headElement = new ElementInfo(true, 1, headStopElements);
        HashSet<String> optionStopElements = new HashSet<String>();
        optionStopElements.add("OPTION");
        optionStopElements.add("SELECT");
        ElementInfo optionElement = new ElementInfo(true, 1, optionStopElements);
        HashSet<String> paragraphStopElements = new HashSet<String>();
        paragraphStopElements.add("P");
        paragraphStopElements.add("DIV");
        paragraphStopElements.add("TABLE");
        paragraphStopElements.add("PRE");
        paragraphStopElements.add("UL");
        paragraphStopElements.add("OL");
        ElementInfo paragraphElement = new ElementInfo(true, 1, paragraphStopElements);
        elementInfos.put("SCRIPT", onlyText);
        elementInfos.put("STYLE", onlyText);
        elementInfos.put("TEXTAREA", onlyTextDE);
        elementInfos.put("IMG", forbiddenEndElement);
        elementInfos.put("META", forbiddenEndElement);
        elementInfos.put("LINK", forbiddenEndElement);
        elementInfos.put("BASE", forbiddenEndElement);
        elementInfos.put("INPUT", forbiddenEndElement);
        elementInfos.put("FRAME", forbiddenEndElement);
        elementInfos.put("BR", forbiddenEndElement);
        elementInfos.put("HR", forbiddenEndElement);
        elementInfos.put("EMBED", forbiddenEndElement);
        elementInfos.put("SPACER", forbiddenEndElement);
        elementInfos.put("P", paragraphElement);
        elementInfos.put("LI", optionalEndElement);
        elementInfos.put("DT", optionalEndElement);
        elementInfos.put("DD", optionalEndElement);
        elementInfos.put("TR", optionalEndElement);
        elementInfos.put("TH", tableCellElement);
        elementInfos.put("TD", tableCellElement);
        elementInfos.put("HEAD", headElement);
        elementInfos.put("OPTION", optionElement);
        elementInfos.put("A", optionalEndElement);
        elementInfos.put("ANCHOR", optionalEndElement);
    }
}

